import cron from 'node-cron';
import { exec } from 'child_process';
import path from 'path';

console.log('Starting YouTube Niche Finder background cron runner...');

// Run every day at Midnight UTC
cron.schedule('0 0 * * *', () => {
    console.log('Running daily channel stats update [CRON] =>', new Date().toISOString());

    exec(`node ${path.resolve('scripts/updateStats.mjs')}`, (error, stdout, stderr) => {
        if (error) {
            console.error(`Cron execution error: ${error}`);
            return;
        }
        if (stderr) {
            console.error(`Cron stderr: ${stderr}`);
            return;
        }
        console.log(`Cron output: ${stdout}`);
    });

}, {
    scheduled: true,
    timezone: "UTC"
});

console.log('Cron scheduler active. Waiting for 00:00 UTC.');
